package org.msh.tb.export_rest.core;

/**
 * Abstract implementation of the {@link BlockReaderImpl}
 * Created by rmemoria on 19/7/17.
 */
public abstract class BlockReaderImpl implements BlockReader {

    private Record record;

    private int recordIndex;

    /**
     * Read the next record
     *
     * @return the instance of {@link Record} or null if it has reached the end
     */
    protected abstract Record readNext();

    @Override
    public long getRecordCount() {
        return 0;
    }

    @Override
    public Record current() {
        if (record == null) {
            return next();
        }
        return record;
    }

    @Override
    public Record next() {
        record = readNext();

        // update the record index
        if (record != null) {
            recordIndex++;
        }

        return record;
    }

    /**
     * Return the current record index
     *
     * @return
     */
    public int getRecordIndex() {
        return recordIndex;
    }
}
